<?php

function print_r_pre($donnees, $nom = '') {	//Affichage des informations pour le debuggage
	echo '<div class="print_r">' . (!empty($nom) ? $nom . " : " : "") . print_r($donnees, true) . "</div>\n\n";
}

//Déclarations
$conf = (new Conf('defaut.conf'))->getDonnees();
$manager = new Manager();
	
class Conf {	//Lectures des propriétés
	
	private $donnees = [];
	
	public function __construct($fichier) {
		$classes = file_get_contents($fichier);
		preg_match_all('/{(.*?) :(.*?)};/is', $classes, $matches);
		for($i = 0; $i < count($matches[0]); $i++) {
			preg_match_all('/(.*?) : (.*)/i', $matches[2][$i], $conf);
			for($j = 0; $j < count($conf[2]); $j++) {
				$attributs = explode(', ', $conf[2][$j]);
				$tab_valeurs_attributs = [];
				foreach($attributs as $element) {
					preg_match('/(.*?) => (.*)/i', $element, $tab_attributs);
					if (!empty($tab_attributs)) $tab_valeurs_attributs[$tab_attributs[1]] = trim(str_replace(' OR ', ', ', $tab_attributs[2]));
					else $tab_valeurs_attributs[trim($element)] = trim($element);
				}
				$this->donnees[$matches[1][$i]][$conf[1][$j]] = $tab_valeurs_attributs;
			}
		}
	}
	
	public function getDonnees() {
		return $this->donnees;
	}
}

class Fonctions_vjemaf {	//Fonctions utilisées
	
	private $chant_edit;
	
	protected function plur($qte, $term = 's') {	//marque le pluriel selon la quantite
		return ($qte > 1 ? $term : '');
	}

	protected function getPost($cle) {	//Retourne la valeur $_POST si non vide
		if (!empty($_POST[$cle]))
			return $_POST[$cle];
	}
	
	protected function getPostParam($cle) {	//Retourne la valeur $_POST ou $conf[Param] si non vide
		$retour = "";
		if ($this->getPost($cle))
			$retour = $_POST[$cle];
		elseif (!empty($this->conf['Param']['simple'][$cle]))
			$retour = $this->conf['Param']['simple'][$cle];
		elseif (!empty($this->conf['Param'][$cle]))
			$retour = $this->conf['Param'][$cle];
		if ($retour)
			return $retour;
	}
	
	protected function getValeur($texte, $tableau) {	//Remplace la clé par la valeur
		foreach($tableau as $cle => $valeur) {
			$texte = str_replace($cle, $valeur . " ", $texte);
		}
		return trim($texte);
	}
	
	protected function getSelectOptions($array, $selecteur, $valeur = 1) {	//Affiche les options d'un select avec présélection (mot-clé de POST)
		$retour = "";
		foreach ($array as $code => $nom) {
			$select = "";
			if (count($array) == 1 OR !empty($_POST[$selecteur]) AND $_POST[$selecteur] == $code)
				$select = " selected";
			elseif (!empty($_POST[$selecteur]) AND is_array($_POST[$selecteur])) {
				foreach($_POST[$selecteur] as $code_select) 
					if ($code_select == $code)
						$select = " selected";
			}
			$retour .= '<option value="' . $code . '"' . $select . '>' . $nom . "</option>\r\n\t";
		}
		return $retour;
	}

	protected function getChecked($code, $selecteur) {	// Coche les checkbox avec présélection (mot-clé de POST)
		$param = $this->getPostParam($selecteur);
		if ($param)
			if (is_array($param) AND in_array($code, $param) OR $code == $param)
				return " checked ";
	}

	protected function getParam($param, $titre) {	// Affiche le paramètre complet prérempli
		$retour = "<h2>" . $titre . "</h2>\n";
		$i = 0;
		foreach($this->conf['Afficher'][$param] as $code => $nom){
			$retour .= '<p><input id="choix_' . $param . '_' . $i . '" name="' . $param . '[]" value="' . $code . '" ' . $this->getFormParam($param . '_param', 0) . $this->getChecked($code, $param) . '/><label for="choix_' . $param . '_' . $i . '" >' . $nom . '</label>' . "\n";
			$i++;
		}
		return $retour;
	}

	protected function ligneIndex($ligne) {	//Retourne une ligne d'index transformée
		$ligne = preg_replace('/^#(.*?)$/', "<a name=\"$1\" nom=\"$1\">&nbsp;</a><h2>$1</h2>\r\n", $ligne);
		$ligne = preg_replace('/¤(.*)/', "<sub>$1</sub>", $ligne);
		$ligne = preg_replace('/^(i:)?(.*?):(.*)$/', "$1<span>$2</span>$3", $ligne);
		$ligne = preg_replace('/^i:(.*)$/', "<i>$1</i>", $ligne);
		$ligne = preg_replace('/^<(i|span)>(.*)$/', "<p class=\"res-index\"><$1>$2</p>\r\n", $ligne);
		return $ligne;
	}

	protected function getCles($string_cles) {	//Retourne les mots-clés pour la recherche
		$cles = explode("\r\n", $string_cles);
		foreach($cles as $key => $mot) {
			$cles[$key] = preg_replace(array('/oe/', '/"/'), array('(oe|œ)', '(« | »)'), $mot);
		}
		return $cles;
	}
	
	protected function getLiens($pattern, $contenu) {	//Cherche les ancres du contenu
		preg_match_all($pattern, $contenu, $match, PREG_SET_ORDER);
		$liens = array();
		if (!empty($match))
			foreach($match as $valeurs)
				$liens[$valeurs[1]] = $valeurs[2];
		return ($liens ? $liens : " ");
	}
	
	protected function getFormParam($cle, $id = 1) {	//Liste des paramètres de conf[Formulaire]
		if (isset($this->conf['Formulaire'][$cle])) {
			$donnees = $this->conf['Formulaire'][$cle];
			$retour = ($id ? ' id="' . $cle . '" ' : '');
			$param = array();
			foreach($donnees as $key => $value)
				$param[] = $key . '="' . $value . '"';
			$retour .= implode(" ", $param);
			return $retour;
		}
	}

	protected function isLivre($code){	//Vérifie si on a un livre de la Bible et retourn le titre
		$trouve = false;
		if (preg_match('/^[a-z0-9:\-\.]+$/i', $code))
			foreach($this->livres_bible as $code_livre => $nom) {
				if (preg_match('/^' . preg_replace('/^s/i', 's?', $code) . '$/i', $code_livre)) $trouve = $nom;
			}
		return $trouve;
	}
		
	protected function extrait_code(){	//Retourne les éléments de la référence
		$code = $this->getPost('code');
		if ($code) {
			if (preg_match('/^(.*?)(:\d+)?(\.\d+)?(\-(?:\d+|f))?(\.(?:\d+|f))?$/i', $code, $ref)) {
				//print_r_pre($ref);
				if (array_key_exists(strtoupper($ref[1]), $this->livres_bible)) {
					$_POST['version'] = 'semeur';
					$_POST['livre'] = strtoupper($ref[1]);
				} elseif(strtolower($ref[1][0]) == "s" AND array_key_exists(strtoupper(substr($ref[1], 1)), $this->livres_bible)) {
					$_POST['version'] = 'segond';
					$_POST['livre'] = strtoupper(substr($ref[1], 1));
				}
				if (!empty($ref[2])) $_POST['chapitre'] = substr($ref[2], 1);
				if (!empty($ref[3])) $_POST['verset_deb'] = substr($ref[3], 1);
				elseif(!empty($ref[4]))
					$_POST['chapitre_fin'] = substr($ref[4], 1);
				if (!empty($ref[4]) AND !empty($ref[5])) {
					$_POST['chapitre_fin'] = substr($ref[4], 1);
					$_POST['verset_fin'] = substr($ref[5], 1);
				} elseif(!empty($ref[4]) AND !empty($ref[3]))
					$_POST['verset_fin'] = substr($ref[4], 1);
				
			}
		}
	}
	
	protected function getMotsCles() {	//Liste des mots-clés en ligne avec couleurs
		$array_cles = explode("\r\n", $_POST['mots-cles']);
		foreach($array_cles as $i => $cle)
			$array_cles[$i] = '<span class="mot-cle Coul_' . $i%5 . '">' . $cle . '</span>';
		return implode(', ' , $array_cles);
	}
		
	protected function getLivre($texte) {	//Formate un livre complet de la Bible
		$retour = preg_replace('/^(Bible:.*?\r\n)/s', '', $texte);
		$retour = preg_replace('/<!--(\d+)_0-->/', '<a name="ch$1" nom="' . (PREV ? 'Ch.' : '') . '$1">&nbsp;</a><h2 class="chapitre">Chapitre $1</h2>', $retour);
		return $retour;
	}
	
	protected function verset_filtre($verset) {	//Prépare le verset sans titres ou codes pour la recherche
		$verset = preg_replace('/<(h.|small|t)>.*?<\/(h.|small|t)>/s', '', $verset);
		return strip_tags($verset);
	}
	
	protected function getVerset($verset, $code_livre, $array_cles) {	//Retourne le verset mis en forme pour les résultats
		foreach($array_cles as $i => $cle)
			$verset = preg_replace('/(' . $cle . ')/is', '<span class="mot-cle Coul_' . $i%5 . "\">$1</span>", $verset);
		$verset = preg_replace('/<!--(\d+)_(\d+)-->(.*?)<small>(.*?)<\/small>/is', "<div class=\"verset\">$3<small>" . $code_livre . ":$1.$2</small>", $verset);
		return $verset . "</div>";
	}

	protected function getElt($tag) {	//Renvoie le contenu du tag dans le chant
		$retour = "";
		if ($this->chant_edit->getElementsByTagName($tag)->length == 1) 
			$retour = $this->chant_edit->getElementsByTagName($tag)->item(0)->textContent;
		return trim($retour);
	}
	
	protected function getEcrans() {	//Renvoie les attributs des écrans
		$liste_parties = implode('|', array_keys($this->conf['Afficher']['Parties']));
		foreach(array('div', 'a', 'data', 'body') as $element) {
			foreach($this->chant_edit->getElementsByTagName($element) as $i => $item) {
				$j = $i + 1;
				if ($element == 'div' AND $item->textContent)
					$_POST['Ecran_' . $j] = $item->textContent;
				foreach($item->attributes as $cle => $attribut) {
					switch($cle) {
						case 'class' : $_POST['Style_' . $j] = $attribut->value; break;
						case 'nom' :
						case 'data-nom' : $nom = $attribut->value;
							if (preg_match('/^(' . $liste_parties . ')(.*)/i', $nom, $match)) {
								$_POST['Partie_' . $j] = trim($match[1]);
								$_POST['Numero_' . $j] = trim($match[2]);
							}
							break;
						case 'data-image' :
						case 'style' : $image = $attribut->value;
							if (preg_match('/background-image:url\(\.*\/fonds\/(.*)\)/i', $image, $match))
								$_POST['edit_image'] = $match[1];
							elseif (preg_match('/^\d{2}$/i', $image, $match)) 
								$_POST['edit_image'] = 'jem@fonds/image' . $match[0] . '.jpg';
							break;
					}
				}
			}
		}
	}
	
	protected function preCharger($code) {	//Charge les informations du chant dans $_POST
		$fichier = '../txt/' . strtolower($code) . '.txt';
		$message = "";
		if (file_exists($fichier)) {
			//Ouverture du fichier
			$this->chant_edit = new DomDocument();
			$contenu = file_get_contents($fichier);
			if (!preg_match('/[àéèœ]/is', $contenu)) $contenu = utf8_encode($contenu);
			$contenu = str_replace(array_keys($this->conf['Afficher']['codage']), array_values($this->conf['Afficher']['codage']), $contenu);
			$contenu = preg_replace('/<span>(.*?)<\/span>/is', "$1", $contenu);
			$contenu = preg_replace('/<div class="Opaque">(.*)<\/div>/is', "$1", $contenu);
			$contenu = str_replace('<div class="saut"></div>', '', $contenu);
			$contenu = str_replace(['', '', '<div class="Opaque">', '& '], ['œ', "'", '', '&amp; '], $contenu);
			$contenu = preg_replace('/(<\/div>)?<\/body>/is', '', $contenu);
			
			//Gestion des erreurs possibles du XML
			$head_xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>";
			$contenu1 =  $head_xml . $contenu;
			
			libxml_use_internal_errors(true);
			$doc = simplexml_load_string($contenu1);
			
			if (!$doc) {
				$errors = libxml_get_errors();
				sort($errors);
				foreach ($errors as $error) {
					switch($error->code) {
						case 5: $contenu1 = $head_xml . "<body>" . $contenu . "</body>"; break;
						case 9: $contenu1 = utf8_encode($contenu1); break;
						case 76: case 77: $contenu1 .= "</body>"; break;
					}
				}
				libxml_clear_errors();
			}
			$this->chant_edit->loadXML($contenu1);
			
			$_POST['edit_ref'] = $this->getElt('sub');
			$_POST['edit_titre'] = trim(str_replace($_POST['edit_ref'], '', $this->getElt('h1')));
			$_POST['edit_compositeur'] = $this->getElt('h2');
			$h4 = $this->getElt('h4');
			if ($h4) {
				$h4_array = explode("\n", $h4);
				foreach($h4_array as $i => $ligne) {
					if (!$i) {}
					elseif (preg_match('/Texte de (.*)/i', $ligne, $match))
						$_POST['edit_auteur'] = trim($match[1]);
					elseif (preg_match('/© (.*)/i', $ligne, $match)) 
						$_POST['edit_copyright'] = trim($match[1]);
					else $_POST['edit_commentaire'] = trim($ligne);
				}
			}
			$this->getEcrans();
			
		} else $message = "Le fichier n'existe pas.";
		return $message;
	}
	
	protected function majIndex() {	//Mise à jour de l'index
		$message = "";
		$ajout = [];
		$chant = strtoupper($this->getPost('chant'));
		$recueil = $this->getPost('edit_recueil');
		$fichier = '../txt/i' . $recueil . '.txt';
		$index = (file_exists($fichier) ? preg_replace('/\r\n?/',"\n", file_get_contents($fichier)) : "");
		//Titre principal
		$index = preg_replace('/\n' . $chant . ':(.*)/i', "\n" . $chant . ':' . $this->getPost('edit_titre'), $index, -1, $nb);
		if ($this->getPost('edit_titre') AND !$nb) 
			$ajout[] = array('', '', $chant, $this->getPost('edit_titre') . ($this->getPost('edit_ref') ? '¤' . $this->getPost('edit_ref') : ""));
		//Titre secondaire
		$index = preg_replace('/\ni:' . $chant . ':(.*)/i', "\ni:" . $chant . ':' . $this->getPost('edit_titre2'), $index, -1, $nb);
		if (($this->getPost('edit_titre2')) AND !$nb) 
			$ajout[] = array('', 'i', $chant, $this->getPost('edit_titre2'));
		
		$index_explode = explode("\n", $index);
		foreach($index_explode as $ligne) {
			preg_match('/^(i)?:?(.*?):(.*)$/i', $ligne, $match_ligne);
			if ($match_ligne)
				$match[] = $match_ligne;
		}
		$match = array_merge($match, $ajout);
		$contenu = $initiale = "";
		array_multisort(array_column($match, 3), $match);	//Trie le tableau par ordre alphabétique des titres
		foreach($match as $donnees) {
			if ($initiale != $donnees[3][0]) {
				$initiale = $donnees[3][0];
				$contenu .= "#" . $initiale . "\r\n";
			}
			$contenu .= ($donnees[1] ? $donnees[1] . ":" : "") . $donnees[2] . ":" . trim($donnees[3]) . "\r\n";
		}
		
		if (file_put_contents($fichier, $contenu))
			$message = ' L\'index "' . $this->conf['Param']['Recueil_sup'][$recueil] . '" a été mis à jour.';
		
		return $message;
	}
	
	protected function enregistreImage() {	//Enregistrement et réduction d'une image
		$message = "";
		if (!$_FILES['nv-image']['error']) {
			$temporaire = '../fonds/temp';
			move_uploaded_file($_FILES['nv-image']['tmp_name'], $temporaire);
			if ($_FILES['nv-image']['type'] == "image/png")
				$image = @imagecreatefrompng($temporaire);
			else $image = imagecreatefromjpeg($temporaire);
			$taille = array(imagesx($image), imagesy($image), 1024, 768);
			$proportion = array($taille[0] / $taille[1], $taille[2] / $taille[3]);
			$destination = array(0, 0, $taille[2], $taille[3]);
			if ($proportion[0] < $proportion[1]) {	//Image plus haute
				if ($taille[0] < $taille[2])	// Largeur trop petite
					$destination[2] = $taille[0];
				$destination[3] = $taille[1] * $destination[2] / $taille[0];
				$destination[0] = max(0, ($destination[2] - $taille[0]) / 2);
			} else {	//Image plus large
				if ($taille[1] < $taille[3])	// Hauteur trop petite
					$destination[3] = $taille[1];
				$destination[2] = $taille[0] * $destination[3] / $taille[1];
				$destination[1] = max(0, ($destination[3] - $taille[1]) / 2);
			}
			$taille_finale = array(max($destination[2],$taille[2]), max($destination[3],$taille[3]));
			$fond = imagecreatetruecolor($taille_finale[0], $taille_finale[1]);
			imagecopyresampled($fond, $image, $destination[0], $destination[1], 0, 0, $destination[2], $destination[3], $taille[0], $taille[1]);
			$fichier = $_FILES['nv-image']['name'];
			if ($taille_finale[0] > $taille[2] OR $taille_finale[1] > $taille[3]) {
				$fichier = str_replace('.', '_dec.', $fichier);
				$message = "Veuillez redécouper l'image suivante :";
			}
			$fichier = '../fonds/' . preg_replace('/\.png/i', '.jpg', $fichier);
			if (imagejpeg($fond, $fichier) AND !$message)
				$message = "L'image a été ajoutée.";
			unlink($temporaire);
		}
		else {
			switch($_FILES['nv-image']['error']) {
				case 1 : case 2 : $message = "Le fichier est trop volumineux. Taille maximale : 10Mo."; break;
				case 4 : $message = "Aucun fichier n'a été envoyé.";
			}
		}
		return $message;
	}
	
	protected function decoupeImage() {	//Enregistrement et réduction d'une image
		$message = "";
		preg_match('/^srcfonds\/(.*?)w(\d+)(?:Left-(\d+))?(?:Top-(\d+))?$/i', $this->getPost('image-offset'), $match);
		$proportion = 1024 / $match[2];
		$fichier = '../fonds/' . $match[1];
		if (file_exists($fichier)) {
			$image = imagecreatefromjpeg($fichier);
			$destination = imagecreatetruecolor(1024, 768);
			imagecopyresampled($destination, $image, 0, 0, $match[3] * $proportion, (isset($match[4]) ? $match[4] : 0) * $proportion, 1024, 768, 1024, 768);
			if(imagejpeg($destination, '../fonds/' . preg_replace('/(.*?)_dec\./i', "$1.", $match[1])))
				$message = "L'image a été découpée.";
			unlink($fichier);
		}
		else $message = "Le fichier n'existe plus.";
		return $message;
	}
	
	protected function enregistre() {	//Enregistrement le fichier d'édition
		$message = "";
		if ($this->getPost('chant')) {
			$enregistre = "<h1>" . $this->getPost('edit_titre') . ($this->getPost('edit_ref') ? "\n<sub>" . $this->getPost('edit_ref') . "</sub>" : "") . "</h1>\n";
			$enregistre .= "<h2>" . $this->getPost('edit_compositeur') .  "</h2>\n";
			$enregistre .= "<h4>" . strtoupper($this->getPost('chant')) . ". " . $this->getPost('edit_titre') . ($this->getPost('edit_ref') ? ". " . $this->getPost('edit_ref'): "");
			if ($this->getPost('edit_auteur')) $enregistre .= "\nTexte de " . $this->getPost('edit_auteur');
			if ($this->getPost('edit_commentaire')) $enregistre .= "\n" . $this->getPost('edit_commentaire');
			if ($this->getPost('edit_copyright')) $enregistre .= "\n© " . $this->getPost('edit_copyright');
			$enregistre .= "</h4>\n";
			for($i = 1; $i <= 20; $i++) {
				if ($this->getPost('Ecran_' . $i)) {
					$_POST['Ecran_' . $i] = str_replace('\t', "\t", $this->getPost('Ecran_' . $i));
					$enregistre .= '<div class="' . $this->getPost('Style_' . $i) . '" data-nom="' . $this->getPost('Partie_' . $i) . $this->getPost('Numero_' . $i) . '">' . $this->getPost('Ecran_' . $i) . "</div>\n";
				}
			}
			$image = $this->getPost('edit_image');
			if ($image) {
				$code_image = "";
				if (preg_match('/jem@fonds\/image(\d{2}).jpg/i', $image, $match))
					$image = $match[1];
				$enregistre .= '<data data-image="' . $image . '"></data>';
			}
			if (file_put_contents('../txt/' . $this->getPost('chant') . '.txt', $enregistre)) {
				global $numero;
				$numero = $this->getPost('chant');
				$message = "Le fichier a été enregistré.";
			}		
		} else $message = "Vous n'avez pas indiqué de code.";
		
		return $message;
	}
	
}

class Manager extends Fonctions_vjemaf {	//Gestion des pages

	protected $titre, $contenu, $numero, $prev_titre, $liens, $conf, $livres_bible, $recueils, $liste_recueils, $versions;
	
	public function __construct() {
		global $conf;
		$this->conf = $conf;
		$this->livres_bible = array_merge($this->conf['Bible']['Livres_AT'], $this->conf['Bible']['Livres_NT']);
		//Liste des recueils de chant utilisés
		$this->recueils = (!empty($this->conf['Param']['Recueil_sup']) ? array_merge($this->conf['Afficher']['Recueils'], $this->conf['Param']['Recueil_sup']) : $this->conf['Afficher']['Recueils']);
		$recueils_utils = (!empty($this->conf['Param']['Recueil_Util']) ? array_merge($this->conf['Param']['Recueils'], $this->conf['Param']['Recueil_Util']) : $this->conf['Param']['Recueils']);
		foreach($recueils_utils as $nom)
			$this->liste_recueils[$nom] = $this->recueils[$nom];
		//Liste des versions bibliques
		foreach($this->conf['Param']['Versions'] as $nom)
			$this->versions[$nom] = $this->conf['Afficher']['Versions'][$nom];
	}
	
	public function renvoi() {	//Renvoi aux différentes pages
		if (!empty($_GET)) {
			if (isset($_GET['accueil'])) $this->accueil();
			elseif (isset($_GET['chant'])) $this->chant($_GET['chant']);
			elseif (isset($_GET['liste']) AND empty($_GET['liste'])) $this->liste();
			elseif (isset($_GET['liste'])) $this->liste_recueil($_GET['liste']);
			elseif (isset($_GET['rech-chant'])) $this->rech_chant();
			elseif (isset($_GET['choix-b'])) $this->choix_passage();
			elseif (isset($_GET['lecture-b'])) $this->lecture_biblique();
			elseif (isset($_GET['rech-b'])) $this->rech_biblique();
			elseif (isset($_GET['redirige'])) $this->redirige();
			elseif (isset($_GET['parametres'])) $this->parametres();
		}
	}
	
	public function accueil() {	//Page d'accueil
		$page = file_get_contents('../txt/accueil.txt');
			
		$page = preg_replace('/<(h\d|li|p.*?)>(.*?)<\/(.*?)>/is', "<$1><span>$2</span></$3>", $page);
			
		$this->contenu = $page;
		$this->numero = 'accueil';
		$this->titre = "Accueil | v-jemaf 6";
	}
	
	public function chant($code) {	//Afficher un chant
		$this->titre = "Ecran noir";
		$this->numero = $code;
		if ($code) {
			$file = '../txt/' . strtolower($code) . '.txt';
			if (file_exists($file)) {
				$page = file_get_contents($file);
				preg_match('/<h1>(.*?)(?:<sub>.*?)?<\/h1>/is', $page, $match);
				if (!empty($match[1])) {
					$this->titre = strtoupper($code) . " - " . $match[1];
					$this->prev_titre = $match[1];
				}
				$page = preg_replace('/<h(\d)>(.*?)<\/h.>/is', "<h$1><span>$2</span></h$1>", $page);
				$page = preg_replace('/<sub>(.*?)<\/sub>/is', "<sub><span>$1</span></sub>", $page);
				$page = preg_replace_callback('/(<div .*?>)(.*?)<\/div>/is', function($match){
					static $nb_pages=1;
					$repere = "";
					if (PREV) {
						preg_match('/data-nom=\"(.+)\"/i', $match[1], $match_nom);
						if (!empty($match_nom[1]))
							$repere = "<h3><span>" . $this->getValeur($match_nom[1], $this->conf['Afficher']['Parties']) . "</span></h3>";
					}
					return "<a name=\"p" . $nb_pages++ . "\">&nbsp;</a>" . $repere . $match[1] . "<span>" . $match[2] . "</span></div>";
				}, $page);
				
				$fond = "";
				preg_match('/data-image=\"(.+?)\"/i', $page, $match);
				if (!empty($match[1]))
					$fond = ' style="background-image: url(fonds/' . (preg_match('/^\d{2}$/i', $match[1]) ? 'jem@fonds/image' . $match[1] . '.jpg' : $match[1]) . ');';
				
				$this->contenu = '<div class="chant ' . $this->conf['Param']['simple']['Style'] . ' ' . (!PREV ? $this->conf['Param']['simple']['Sauts'] : 'sauts_sans') . (($fond AND $this->conf['Param']['simple']['Photos'] == 'photo_avec') ? ' fond" ' . $fond : '') . '">' . $page . "\r\n<img id=\"fin\" src=\"img/fin.png\" title=\"Fin du chant\"></div>";
				
				$this->liens = $this->getLiens('/<a name="(p\d+)">.*?data-nom="(.*?)"/is', $page);
			} else $this->prev_titre = "Fichier inexistant";
		}
	}
	
	public function liste() {	//Afficher un chant - choisir un recueil
		$this->titre = "Afficher un chant";
		$page = "<div><h1>" . $this->titre . "</h1>\n";
		$page .= "<h2>Recueil :</h2>\n";
		foreach ($this->liste_recueils as $code => $nom)
			$page .= '<a class="recueil" href="' . PREV . 'liste=' . $code . '">' . $nom . '</a>';
		$this->contenu = $page . "</div>";
	}
	
	public function liste_recueil($recueil) {	//Afficher l'index d'un recueil
		$fichier = '../txt/i' . $recueil . '.txt';
		$nom_recueil = $this->recueils[$recueil];
		$this->numero = "i" . $recueil;
		$this->titre = "Index de « " . $nom_recueil . " »";
		$page = "<div><h1>" . $this->titre . "</h1>\n<div class=\"index\">";
		if (file_exists($fichier)) {
			$index = explode("\r\n", file_get_contents($fichier));
			foreach($index as $num => $ligne) {
				$page .= $this->ligneIndex($ligne);
			}
		} else $page .= '<p class="message">Le fichier n\'existe plus.</p>';
		$page .= "</div></div>";
		
		$this->contenu = $page;
		$this->liens = $this->getLiens('/<a name="(.*?)" nom="(.*?)">/i', $page);
	}
	
	public function rech_chant() {	//Rechercher un chant
		$this->titre = "Rechercher un chant";
		$page = "<div class=\"recherche\"><h1>" . $this->titre . "</h1>\n";
		$page .= '<form class="form flex" method="POST">
			<div><div><label for="mots-cles">Mots-clés :</label><textarea ' . $this->getFormParam("mots-cles") . '>' . $this->getPost('mots-cles') . '</textarea></div></div>
			<div><div><label for="recueils">Recueils :</label><select ' . $this->getFormParam("recueils") . '>' . $this->getSelectOptions($this->liste_recueils, 'recueils') . '</select></div></div>
			<div><div><label for="rech-dans">Dans :</label><select ' . $this->getFormParam("rech-dans") . '>' . $this->getSelectOptions($this->conf['Afficher']['rech-dans-c'], 'rech-dans') . '</select></div></div>
			<div><div><input type="submit" class="bouton" value="Rechercher" /></div></div>
			</form>';
		
		if (empty($_POST)) 
			$page .= "<p>Aucune recherche actuellement</p>";
		else {
			$page .= "<h3>Recherche dans les " . $_POST['rech-dans'] . " — Mots-clés : " . str_replace("\r\n", ", ", $_POST['mots-cles']) . "</h3><div class=\"index\">\n";
			$nb_total = 0;
			foreach($_POST['recueils'] as $code_recueil) {
				$nom_recueil = $this->liste_recueils[$code_recueil];
				$page .= "<a name=\"" . $code_recueil . "\" nom=\"" . $nom_recueil . "\">&nbsp;</a>\n";
				$page .= "<h2 class=\"resume\">" . $nom_recueil . "</h2>\n<div class=\"details\">";
				$fichier = '../txt/i' . $code_recueil . '.txt';
				if (file_exists($fichier)){
					$index = explode("\r\n", file_get_contents($fichier));
					$nb_recueil = 0;
					foreach($index as $ligne_index) {
						preg_match('/(?:i\:)?(.*?):(.+)/i', $ligne_index, $match);
						if (!empty($match[1])) {
							$num = strtolower($match[1]);
							$cles = $this->getCles($_POST['mots-cles']);
							if ($_POST['rech-dans'] == 'paroles')
								$chant = strip_tags(file_get_contents('../txt/' . $num . '.txt'));
							else $chant = $match[2];
							$trouve_tous =  0;
							foreach($cles as $cle)
								if(preg_match('/' . $cle . '/is', $chant))
									$trouve_tous += 1;
							if ($trouve_tous == count($cles)) {
								$page .= $this->ligneIndex($ligne_index);
								$nb_recueil++;
							}
						}
					}
					$page .= '</div>';
				} else $page .= '</div><p class="message">Le fichier n\'existe plus.</p>';
				$page .= '<div class="nb_recueil">' . $nb_recueil . ' résultat' . $this->plur($nb_recueil) . "</div>\n";
				$nb_total += $nb_recueil;
			}
			$page .= '<div class="nb_total">Total : ' . $nb_total . ' résultat' . $this->plur($nb_total) . '</div></div></div>';
		}
		
		$this->contenu = $page;
		$this->liens = $this->getLiens('/<a name="(.*?)" nom="(.*?)">/i', $page);
	}
	
	public function choix_passage() {	//Afficher un passage biblique
		$this->titre = "Choix du passage biblique";
		$page = "<div><h1>" . $this->titre . "</h1>\n";
		$page .= '<form class="form flex" method="POST" action="' . PREV . 'lecture-b">
			<div><div><label for="version">Version bible :</label><select ' . $this->getFormParam("version") . '>' . $this->getSelectOptions($this->versions, 'version') . '</select></div></div>
			<div><div><label for="livre_AT">Ancien testament :</label><select ' . $this->getFormParam("livre_AT") . ' size="' . (PREV ? 5 : 25) . '">' . $this->getSelectOptions($this->conf['Bible']['Livres_AT'], 'livre') . '</select></div></div>
			<div><div><label for="livre_NT">Nouveau testament :</label><select ' . $this->getFormParam("livre_NT") . ' size="' . (PREV ? 5 : 25) . '">' . $this->getSelectOptions($this->conf['Bible']['Livres_NT'], 'livre') . '</select></div></div>
			<div><div><label for="chapitre">Chapitre :</label><input ' . $this->getFormParam("chapitre") . ' value="' . $this->getPost('chapitre') . '"/>
			<br/><br/><label for="verset_deb">Versets  :</label>de <input ' . $this->getFormParam("verset_deb") . ' value="' . $this->getPost('verset_deb') . '"/>
			<br/>à <input ' . $this->getFormParam("verset_fin") . ' value="' . $this->getPost('verset_fin') . '"/></div></div>
			<div><div><input class="bouton" type="submit" value="Afficher" /></div></div>
			</form></div>';
				
		$this->contenu = $page;
	}
	
	public function lecture_biblique() {	//Afficher un passage biblique
		$this->extrait_code();
		$code_livre = ($this->getPost('version') == "segond" ? "s" : "") . strtolower($this->getPost('livre'));
		$file = '../txt/' . $code_livre . '.txt';
		$passage = "";
		if (file_exists($file)) {
			$page = file_get_contents($file);
			$chapitre = $this->getPost('chapitre');
			$chapitre_fin = $this->getPost('chapitre_fin');
			$verset_deb = $this->getPost('verset_deb');
			$verset_fin = strtolower($this->getPost('verset_fin'));
			if (!$chapitre) $passage = $page;
			else {
				preg_match('/<!--' . $chapitre . '_' . ($verset_deb ? $verset_deb : '0') . '-->.*?<!--(' . ($chapitre_fin ? $chapitre_fin : $chapitre) . '|f)_(?:' . ($verset_fin ? $verset_fin + 1 : ($verset_fin == "f" ? "f" : ($verset_deb ? $verset_deb + 1 : ""))) . '|f)-->/s', $page, $texte1);
				if (!empty($texte1[0]))
					$passage = $texte1[0];
			}
			$passage = $this->getLivre($passage);
			
			//Références
			preg_match('/^(Bible:.*?)\r\n/is', $page, $ref);
			$ref1 = explode(":", $ref[1]);
			//print_r_pre($ref1);
			$reference = "Chapitre " . $chapitre . ($verset_deb ? " verset " . $verset_deb . ($verset_fin ? ($chapitre_fin ? " à chapitre " . $chapitre_fin . ($verset_fin == "f" ? " jusqu'à la fin" : " verset " . $verset_fin) : ($verset_fin == "f" ? " jusqu'à la fin" : " à " . $verset_fin )) : "") : ($chapitre_fin ? " à " . $chapitre_fin : ""));
			$entete = '<div class="Ref"><h1>' . $ref1[2] . "</h1>" . ($chapitre ? "\r\n<h2>" . $reference . "</h2>" : "") . "\r\n<h4>" . strtoupper($code_livre) . ". " . $ref1[2] . ($this->getPost('version') ? "<br/>\r\n" . $this->conf['Afficher']['Version-Aff'][$this->getPost('version')] : "") . "</h4></div>\r\n";
			
			$this->titre = $this->isLivre($code_livre) . ($chapitre ? " " . str_replace(['Chapitre', 'chapitre', 'verset', ' à ', 'jusqu\'à la'], [': ch.', 'ch.', 'v.', ' - ', ' ->'], $reference) : "");
						
			$this->contenu = '<div class="div-Bible Bible ' . $this->conf['Param']['simple']['Style'] . '">' . $entete . $passage . '</div>';
			
			$this->numero = strtolower($code_livre) . ($chapitre ? ":" . $chapitre . ($verset_deb ? "." . $verset_deb . ($verset_fin ? ($chapitre_fin ? "-" . $chapitre_fin . "." : "-") . $verset_fin : "") : ($chapitre_fin ? "-" . $chapitre_fin : "")) : "");

			$this->liens = $this->getLiens('/<a name="(.*?)" nom="(.*?)">/i', $passage);
		} elseif ($code_livre) $this->contenu = '</div><p class="message Bible">Le fichier ' . $code_livre . '.txt n\'existe plus.</p>';
	}
	
	public function rech_biblique() {	//Rechercher un verset biblique
		
		$livre_post = $this->getPost('rech-dans-livre');
		$rech_dans = $this->getPost('rech-dans-b');
		$livre = (($livre_post AND array_key_exists($livre_post, $this->livres_bible) AND $rech_dans == "livre") ? $livre_post : "");
		$rech_dans = (($rech_dans == "livre" AND !$livre) ? "bible" : $rech_dans);
		
		$this->titre = "Rechercher un verset";
		$page = "<div class=\"recherche\"><h1>" . $this->titre . "</h1>\n";
		$page .= '<form class="form flex" method="POST">
			<div><div><label for="mots-cles">Mots-clés :</label><textarea ' . $this->getFormParam("mots-cles") . '>' . $this->getPost('mots-cles') . '</textarea></div></div>
			<div><div><label for="rech-version">Version :</label><select ' . $this->getFormParam("rech-version") . '>' . $this->getSelectOptions($this->versions, 'version') . '</select></div></div>
			<div><div><label for="rech-dans-b">Dans :</label><select ' . $this->getFormParam("rech-dans-b") . '>' . $this->getSelectOptions($this->conf['Afficher']['rech-dans-b'], 'rech-dans-b') . '</select></div></div>
			<div><div><input type="submit" class="bouton" value="Rechercher" />
			<div id="div-livre"><label for="rech-dans-livre">Livre :</label><input ' . $this->getFormParam("rech-dans-livre") . " value=\"" . $livre . "\"/>\r\n" . '<datalist id="livres-bible">' . $this->getSelectOptions($this->livres_bible, 'rech-dans-livre') . '</datalist></div>
			</div></div>
			</form>';
		
		if (empty($_POST)) 
			$page .= "<p>Aucune recherche actuellement</p>";
		else {
			$message_erreur = "";
			if ($livre_post AND !array_key_exists($livre_post, $this->livres_bible) AND $rech_dans == "livre")
				$message_erreur = "Le livre demandé n'existe pas";
			$page .= "<p class=\"message\">" . $message_erreur . "</p>\n";
			$page .= "<h3>Recherche dans " . ($livre ? "« " . $this->livres_bible[$livre] . " »" : $this->conf['Bible']['rech-dans'][$rech_dans]) . " — Mots-clés : " . $this->getMotsCles() . "</h3>";
			
			if (count($_POST['version']) > 1) {
				$page .= '<form id="version-bible">Version bible : ';
				foreach($this->conf['Afficher']['Versions'] as $i => $version)
					$page .= '<input type="radio" id="radio_' . $i . '" name="version" ' . ($i == "semeur" ? 'checked' : "") . '>' .  '<label for="radio_' . $i . '">' . $version . '</label>';
				$page .= "</form>";
			}
			else $page .= '<p class="version-Bible"> ' . $this->conf['Afficher']['Version-Aff'][$_POST['version'][0]] . "</p>\r\n";
			
			//Liste des livres
			$liste_livres = [];
			if ($livre) $liste_livres[] = $livre;
			else {
				$array_livres = ($rech_dans == "bible" ? $this->livres_bible : $this->conf['Bible']['Livres_' . $rech_dans]);
				foreach($array_livres as $cle => $valeur) $liste_livres[] = $cle;
			}
			
			$cles = $this->getCles($_POST['mots-cles']);
			
			$page .= "<div id=\"div-res-bible\">\n";
						
			//Version de la Bible
			foreach($_POST['version'] as $version) {
				$s_version = ($version == "segond" ? "S" : "");
				$page .= '<div id="res-' . $version . '" class="index">' . "\n";
				$nb_total = 0;
				//Ouverture de chaque livre
				foreach($liste_livres as $code_livre) {
					$nb_livre = 0;
					$nom_livre = $this->livres_bible[$code_livre];
					$page_temp = "<a name=\"" . $s_version . $code_livre . "\" nom=\"" . $nom_livre . "\">&nbsp;</a>\n";
					$page_temp .= "<h2 class=\"resume\">" . $nom_livre . "</h2>\n<div class=\"details Bible\">";
					$existe = false;
					$fichier = '../txt/' . strtolower($s_version . $code_livre) . '.txt';
					if (file_exists($fichier)) {
						$existe = true;
						$texte_livre = file_get_contents($fichier);
						//Découpage en chapitres
						preg_match_all('/<!--\d+_1-->.*?<!--(\d+|f)_f-->/is', $texte_livre, $chapitres);
						foreach($chapitres[0] as $texte_chapitre){
							//Découpage en versets
							$texte_chapitre = str_replace('<!--', "¤<!--", $texte_chapitre);
							preg_match_all('/(<!--\d+_\d+-->.+?)¤/is', $texte_chapitre, $versets);
							foreach($versets[1] as $verset) {
								//Recherche des mots-cles
								$trouve_tous =  0;
								$verset_filtre = $this->verset_filtre($verset);
								foreach($cles as $cle)
									if(preg_match('/' . $cle . '/is', $verset_filtre))
										$trouve_tous += 1;
								if ($trouve_tous == count($cles)) {
									$page_temp .= $this->getVerset($verset, $s_version . $code_livre, $cles);
									$nb_livre++;
								}
							}
						}
						$page_temp .= '</div>';
					} else $page_temp .= '</div><p class="message">Le fichier n\'existe plus.</p>';
					$page_temp .= '<div class="nb_recueil">' . $nb_livre . ' résultat' . $this->plur($nb_livre) . "</div>\n";
					if ($nb_livre > 0 OR !$existe) $page .= $page_temp;
					$nb_total += $nb_livre;
				}
				$page .= '<div class="nb_total">Total : ' . $nb_total . ' résultat' . $this->plur($nb_total) . '</div></div>';
			}
			$page .= "</div>\n";
		}
		
		$this->contenu = $page . "</div>";
		$this->liens = $this->getLiens('/<a name="(.*?)" nom="(.*?)">/i', $page);
	}
	
	public function redirige(){	//Redirection
		$code = $this->getPost('code');
		$double = ($this->getPost('double_ecran') ? "&double" : "");
		$href = $chant2 = "";
		$lecture_bible = false;
		
		//Lecture biblique
		if ($this->isLivre($code) OR strpos($code, ':') !== false) {
			$href = "lecture-b";
			$lecture_bible = true;
		}
		//jem4
		elseif (preg_match('/^(jem)?(1\d{3})$/i', $code, $chant)) {
			$href = "chant=jem" . $chant[2];
		}
		//jem, jemk, atg
		elseif (preg_match('/^(jemk|jem|atg)?(\d{1,3})$/i', $code, $chant)) {
			$prefixe = (!empty($chant[1]) ? strtolower($chant[1]) : "jem");
			$numero = substr("00" . $chant[2], -3);
			$href = "chant=" . $prefixe . $numero;
		}
		//af
		elseif (preg_match('/^af(\d{1,3})([ab]?)$/i', $code, $chant)) {
			$numero = substr("00" . $chant[1], -3);
			$suffixe = (!empty($chant[2]) ? strtolower($chant[2]) : "");
			$href = "chant=af" . $numero . $suffixe;
		}
		//index
		elseif (preg_match('/^i(' . implode('|', array_keys($this->recueils)) . ')$/i', $code, $index)) {
			$href = "liste=" . $index[1];
		}
		elseif (preg_match('/^accueil$/i', $code, $index)) {
			$href = "accueil";
		}
		else $href = "chant=" . $code;
		
		if ($lecture_bible) {
			$this->titre = "Redirection…";
			echo '<form id="send_ref" method="POST" action="' . PREV . 'lecture-b' . $double . '"><input type="hidden" name="code" value="' . $code . '"></form>';
		} else header('location:' . PREV . $href . $double);
	}
	
	public function parametres() {	//Modification des paramètres
		
		//Enregistrement des données
		$message = "";
		if (!empty($_POST)) {
			$_POST['Recueil_sup'] = $this->conf['Param']['Recueil_sup'];
			foreach($_POST as $cle => $nom) {	//Listes de checkbox
				$ligne_liste = [];
				if (in_array($cle, ['Recueils', 'Versions', 'Recueil_sup', 'Recueil_Util'])) {
					if ($cle == 'Recueil_sup') $nom = $_POST['Recueil_sup'];
					foreach($nom as $cle1 => $nom1) {
						if ($cle1 === "") {}
						elseif ($cle == 'Recueil_sup' AND !file_exists('../txt/i' . $cle1 . '.txt')) {
							$message = "Le recueil <b>" . $this->conf['Param']['Recueil_sup'][$cle1] . "</b> (fichier i" . $cle1 . ".txt) n'existe plus.";
							unset($this->conf['Param']['Recueil_sup'][$cle1]);
						}
						else $ligne_liste[] =  $cle1 . " => " . $nom1;
					}
					$multiple[] = $cle . " : " . implode(', ', $ligne_liste);
				}
				elseif ($cle == 'ajout_recueil') {	//Ajout d'un recueil
					if (!empty($_POST['ajout_recueil'][0]) AND !empty($_POST['ajout_recueil'][1]) AND !isset($_POST['Recueil_sup'][$_POST['ajout_recueil'][0]])) {
						$code = $_POST['ajout_recueil'][0];
						$titre = $_POST['ajout_recueil'][1];
						$_POST['Recueil_sup'][$code] = $titre;
						$_POST['Recueil_Util'][] = $code;
						$this->conf['Param']['Recueil_sup'][$code] = $titre;
						$nv_index = "../txt/i" . $_POST['ajout_recueil'][0] . ".txt";
						if (file_exists($nv_index)) $message = "Le fichier <b>" . $nv_index . "</b> existe déjà.";
						else {
							file_put_contents($nv_index, "");
							$message = "Le fichier <b>" . $nv_index . "</b> a été créé.";
						}
					}
				} else 	//Input simple et radio
					$simple[] = $cle . " => " . (is_array($nom) ? $nom[0] : $nom);
			}
			$sauve = "simple : " . implode(', ', $simple) . "\n" . implode("\n", $multiple);
			$fichier = "defaut.conf";
			$contenu =  file_get_contents($fichier);
			$contenu = preg_replace('/({Param :\r\n)(.*?)(\r\n\};)/is', "$1" . $sauve . "$3", $contenu);
			file_put_contents($fichier, $contenu);
			if (!$message) $message = "Données enregistrées.";
		}
		
		$this->titre = "Paramètres du programme";
		$page = "<div><h1>" . $this->titre . "</h1>\n";
		
		if ($message) $page .= "<p class=\"message\">" . $message . "</p>";
		
		$page .= '<form class="param" method="POST" action="">
			<h2>Licence de projection</h2>
			<p class="comment">Pour projeter les chants de louange en église, vous devez posséder une licence (<a href="http://www.ltc-asaph.com/licensing" target="_blank">http://www.ltc-asaph.com/licensing</a>)</p>
			<p><label for="licence">N° de licence : </label><input' . $this->getFormParam("licence") . " value=\"" . $this->getPostParam('licence') . '"/>' . "\n";
		
		//Paramètres checkbox ou radio
		$page .= $this->getParam('Recueils', 'Recueils utilisés');
		
		$page .= '<h2>Recueils supplémentaires</h2>
			<p class="comment">Vous pouvez ajouter des recueils personnels pour y indexer vos nouveaux chants et les retrouver par la suite. Vous pourrez ensuite faire des recherches sur les paroles.</p>' . "\n";
		
		$i = 0;
		if (!empty($this->conf['Param']['Recueil_sup']))
			foreach($this->conf['Param']['Recueil_sup'] as $code => $nom){
				if ($code !== "")
					$page .= '<p><input id="choix_Recueil_Util_' . $i . '" value="' . $code . '" ' . $this->getFormParam('Recueil_Util', 0) . $this->getChecked($code, 'Recueil_Util') . '/><label for="choix_Recueil_Util_' . $i . '" >' . $nom . '</label>' . "\n";
				$i++;
			}
		
		$page .= '<p><label for="code_nv">Code du recueil : i</label><input' . $this->getFormParam("code_nv") . ' value="' . $this->getPostParam('code_nv') . '"/>.txt</p>
			<p><label for="titre_nv">Titre du recueil : </label><input' . $this->getFormParam("titre_nv") . ' value="' . $this->getPostParam('titre_nv') . '"/></p>';
			
		$page .= $this->getParam('Versions', 'Bibles utilisées');
		$page .= $this->getParam('Style', 'Style d\'affichage');
		$page .= $this->getParam('Photos', 'Photos de fond');
		$page .= $this->getParam('Sauts', 'Sauts de pages');
		$page .= $this->getParam('Ouv_telec', 'Ouverture initiale de la télécommande');
		$page .= $this->getParam('Click_compo', 'Utilisation de la composition');
		
		$page .= "<p><input " . $this->getFormParam("param_submit") . "/></form></div>";
		
		$this->contenu = $page;
	}
	
	public function composition() {	//Editer la composition
		
		$this->contenu = $this->getPost('codes');
		if (!empty($_POST))
			//Enregistrement dans le fichier
			file_put_contents('composition.txt', $this->contenu);
		else $this->contenu = file_get_contents('composition.txt');
		
		$liste = explode("\r\n", $this->contenu);
		$liens = [];
			
		foreach($liste as $donnee){
			$code = $titre = $comment = "";
			if (preg_match('/^(.*?)\/\/(.*)$/i', $donnee, $match)) {
				$donnee = $match[1];
				$comment = trim($match[2]);
			}
			$donnee = strtolower(trim($donnee));
			$isChant = true;
			
			//Livre biblique complet
			if ($titre = $this->isLivre($donnee)) {
				$code = $donnee;
				$titre = $titre;
				$isChant = false;
			}
			//Référence biblique
			elseif (strpos($donnee, ':') !== false) {
				$donnees = explode(':', $donnee);
				$code = $donnee;
				preg_match('/^(\d+)?(\.\d+)?(\-(?:\d+|f))?(\.(?:\d+|f))?$/i', $donnees[1], $ref);
				$titre = $this->isLivre($donnees[0]) . " : ch. " . preg_replace(array('/\./', '/(\-|v\. )f/', '/-(\d)/', '/- (\d+) .(->|v\.)/'), array(" v. ", ' -> fin', " - $1", "- ch. $1 $2"), $donnees[1]);
				$isChant = false;
			}
			//jem4
			elseif (preg_match('/^(jem)?(1\d{3})$/i', $donnee, $chant)) {
				$code = "jem" . $chant[2];
				$isChant = true;
			}
			//jem, jemk, atg
			elseif (preg_match('/^(jemk|jem|atg)?(\d{1,3})$/i', $donnee, $chant)) {
				$prefixe = (!empty($chant[1]) ? strtolower($chant[1]) : "jem");
				$numero = substr("00" . $chant[2], -3);
				$code = $prefixe . $numero;
				$isChant = true;
			}
			//af
			elseif (preg_match('/^af(\d{1,3})([ab]?)$/i', $donnee, $chant)) {
				$numero = substr("00" . $chant[1], -3);
				$suffixe = (!empty($chant[2]) ? strtolower($chant[2]) : "");
				$code = "af" . $numero . $suffixe;
			}
			else $code = $donnee;
			
			if ($isChant) {
				$file = '../txt/' . $code . '.txt';
				if (file_exists($file) AND preg_match('/<h1>(.*?)(<sub>.*?)?<\/h1>/is', file_get_contents($file), $match));
					if (!empty($match[1]))
						$titre = trim($match[1]);
			}
		
			$this->liens[] = "<li><span>" . $code . "</span><p>" . $titre . "</p>" . ($comment ? "<q>" . $comment . "</q>" : "") . "</li>";
			global $contenu, $liens;
			$contenu = $this->contenu;
			$liens = implode('', $this->liens);
		}
	}
	
	public function edition() {	//Editer un chant
		
		global $contenu;
		
		$chant = (!empty($_GET['chant']) ? strtolower($_GET['chant']) : "");
		
		$message = $message_image = "";
		
		if (!$_POST AND $chant)
			$message = $this->preCharger($chant);
				
		$chant = ($this->getPost('chant') ? $this->getPost('chant') : $chant);
		
		if (!empty($_POST['nv-image']))
			$message_image = $this->enregistreImage();
		elseif(!empty($_POST['image-decouper']) AND !empty($_POST['image-offset']))
			$message_image = $this->decoupeImage();
		//Enregistrement
		elseif (!empty($_POST['action'])) {
			$message = $this->enregistre();
			if ($this->getPost('edit_recueil') AND $this->getPost('chant'))
				$message .= $this->majIndex();
		}
		
		$page = '<div class="choix"><div class="bouton">Informations</div><div class="bouton">Paroles</div><div  class="bouton' . ($message_image ? ' actif' : '') . '">Image</div></div>
			<form id="choix-edition" method="POST" enctype="multipart/form-data" action="">';
			//Informations
			$page .= '<fieldset id="edit_info"><legend>Informations</legend>
				<div class="form">
					<div id="choix_code">
						<label for="edit_code">Code du chant :</label><input ' . $this->getFormParam('edit_code') . ' value="' . $chant . '"/>
						<input type="button" class="bouton" id="edit_charger" value="charger" />';
					if ($message)
						$page .= '<p class="message">' . $message . '</p>';
					$page .= '</div>';
						$i = 1;
						foreach($this->conf['Afficher']['edit_label'] as $cle => $label) {
							$page .= '<label for="edit_' . $cle . '">' . $label . ' :</label><input ' . $this->getFormParam('edit_' . $cle) . ' value="' . $this->getPost('edit_' . $cle) . '"/>';
							if ($i == 7) {
								$page .= "<label></label><br/>";
								$i++;
							}
							$page .= (($i % 2 == 0 OR $i == 7) ? "<br/>\n" : "");
							$i++;
						}
						
						if (!empty($this->conf['Param']['Recueil_sup'])) $page .= '<datalist id="recueils-sup">' . $this->getSelectOptions($this->conf['Param']['Recueil_sup'], 'edit_recueil') . '</datalist>';
			$page .= '</fieldset>';
			
			//Paroles
			unset($this->conf['Afficher']['Parties']['Ch.']);
			$page .= '<fieldset id="edit_paroles"><legend>Paroles</legend>
				<div class="form">';
					$page .= '<div class="header">Ecrans</div>';
					for($i = 1; $i <= 20; $i++) {
						$page .= '<div id="Ecran_' . $i . '"><span>' . $i . '</span>
							<textarea name="Ecran_' . $i . '">' . $this->getPost('Ecran_' . $i . '') . '</textarea>
							<div class="col"><label for="Style_' . $i . '">Style :</label><select name="Style_' . $i . '" type="text" >' . $this->getSelectOptions($this->conf['Afficher']['Styles'], 'Style_' . $i) . '</select>
								<label for="Partie_' . $i . '">Partie :</label><select name="Partie_' . $i . '" type="text" >' . $this->getSelectOptions($this->conf['Afficher']['Parties'], 'Partie_' . $i) . '</select>
								<label for="Numero_' . $i . '">Numero :</label><input name="Numero_' . $i . '" type="text" value="' . $this->getPost('Numero_' . $i . '') . '"/></div></div>';
					}
			$page .= '</fieldset>';
			
			//Images
			$page .= '<fieldset id="edit_images"><legend>Image</legend>
				<div class="form">
					<div class="header">Images fournies (jem@fonds)</div>
					<ul id="jem-fonds">';
					for($i = 0; $i < 90; $i++) 
						$page .= '<li title="jem@fonds/image' . sprintf('%02d', $i + 1) . '.jpg" style="background-position: -' . (132 * ($i % 5)) . 'px -' . (99 * floor($i / 5)) . 'px;" /></li>';
					$page .= '</ul>';
					
					$dossier = scandir('../fonds');
					$i = 0;
					$page .= '<div class="header">Images personnelles</div>
						<ul id="images-autres">';
					$image_decouper = "";
					foreach($dossier as $fichier) {
						if (preg_match('/.+\.(jpe?g|png|gif)/i', $fichier)) {
							$page .= '<li title="' . $fichier . '" style="background-image: url(fonds/' . $fichier . ');" /></li>';
							if (preg_match('/_dec\.(jpg|gif)$/i', $fichier))
								if (!$image_decouper)
									$image_decouper = $fichier;
						}
					}
					$page .= '</ul>
						<div id="div-nv-image"><label for="nv-image">Nouvelle image : </label><input ' . $this->getFormParam('nv-image') . '/><input type="submit" class="bouton" name="nv-image" id="edit_nv_image" value="Enregistrer" />';
					if ($message_image)
						$page .= '<p class="message">' . $message_image . '</p>';
					$page .= '</div>';
					if ($image_decouper) {
						$page .= '<div id="image_decouper" title="Glisser l\'image dans le cadre à l\'aide de la souris."><img src="fonds/' . $image_decouper . '" /></div><input type="hidden" name="image-offset" id="image-offset" /><input class="bouton" type="submit" name="image-decouper" id="edit_dec_image" value="Découper" />
						</div>';
					}					
					
			$page .= '</fieldset>';
			$page .= '<input type="submit" class="bouton" name="action" id="edit_enregistrer" value="Enregistrer" />
		</form>';
		
		
		$contenu = $page;
	}
	
	public function getPage() {	//Retourne les informations de la page
		global $titre, $contenu, $numero, $liens;
		$titre = ($this->titre ? $this->titre : 'v-jemaf 6 | Programme de vidéoprojection');
		$contenu = $this->contenu;
		$numero = $this->numero;
		
		$liste_liens[] = '<a class="actif" href="#">Titre</a>';
		if (is_array($this->liens)) {
			foreach($this->liens as $name => $nom) 
				$liste_liens[] = '<a href="#' . $name . '">' . $nom . '</a>';
			$liens = implode(' - ' , $liste_liens);
		}
	}
	
	public function getPrevisu() {	//Retourne les informations pour la prévisualisation
		global $contenu, $numero, $liens;
		$contenu = $this->contenu;
		$this->prev_titre = ($this->prev_titre ? $this->prev_titre : $this->titre);
		
		$liste_liens[] = '<li class="actif" href="">Titre</li>';
		if (is_array($this->liens)) {
			foreach($this->liens as $name => $nom) 
				$liste_liens[] = '<li href="' . $name . '">' . $this->getValeur($nom, $this->conf['Afficher']['Parties']) . '</li>';
			$liens = implode('' , $liste_liens);
		}
		if ($this->numero OR $this->prev_titre)
			$numero = '<span class="prev_numero">' . $this->numero . '</span>' . (($this->numero AND $this->prev_titre) ? '. ' : '') . '<span class="prev_titre">' . $this->prev_titre . '</span>';
	}
}